/*
 * Decompiled with CFR 0.152.
 */
package org.apcc.api.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileOutputStream;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apcc.api.client.ClientEnvironment;
import org.apcc.api.client.RestTemplateConfig;
import org.apcc.api.jobdetails.JobDetails;
import org.apcc.api.jobdetails.JobDetailsCMIP5;
import org.apcc.api.jobdetails.JobDetailsMME;
import org.apcc.api.jobdetails.JobDetailsModel;
import org.apcc.api.jobdetails.JobStatus;
import org.apcc.api.jobdetails.Request;
import org.apcc.api.response.APCCResponse;
import org.apcc.api.response.APCCResponseStatus;
import org.apcc.api.response.InfoResponse;
import org.apcc.api.response.auth.UserInfoResponse;
import org.apcc.api.response.job.JobInfoData;
import org.apcc.api.response.job.JobResponse;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.client.RestClientResponseException;
import org.springframework.web.client.RestTemplate;

public class APIClient {
    private String userkey = "";
    private String curJobID = "";
    private String target = "";
    private JobInfoData curJobInfo = null;
    private ClientEnvironment env = new ClientEnvironment();
    private JobDetails jobDetails = null;

    public APIClient() throws Exception {
        this.userkey = this.env.getKey();
    }

    public void run(String details, String target) {
        if (target == null || target.length() == 0) {
            this.printMessage("[Error] Please input target file path.");
            return;
        }
        this.jobDetails = this.toJobDetails(details);
        if (this.jobDetails == null) {
            this.printMessage("[Error] Invalid parameters. Please check input parameters.");
            return;
        }
        this.run(this.jobDetails, target);
    }

    /*
     * Unable to fully structure code
     */
    public void run(JobDetails details, String target) {
        if (target == null || target.length() == 0) {
            this.printMessage("[Error] Please input target file path.");
            return;
        }
        this.target = target;
        request = new Request();
        request.setKey(this.userkey);
        request.setDetails(details);
        this.jobDetails = details;
        res = this.sendRequest(request);
        if (res == null) {
            this.printMessage("[Error] Failed to process your request.");
            return;
        }
        curStatus = this.checkJobStatus(res);
        if (curStatus != JobStatus.FAILED) ** GOTO lbl22
        return;
lbl-1000:
        // 1 sources

        {
            try {
                Thread.sleep(5000L);
            }
            catch (Exception var6_6) {
                // empty catch block
            }
            curStatus = this.checkJobStatus();
lbl22:
            // 2 sources

            ** while (curStatus != JobStatus.COMPLETE && curStatus != JobStatus.FAILED)
        }
lbl23:
        // 1 sources

        if (curStatus == JobStatus.COMPLETE) {
            try {
                this.download();
            }
            catch (Exception ex) {
                this.printMessage("[Error] Failed to download your request file : " + this.curJobInfo.getDownload_url());
            }
        }
        this.printMessage("[Info] Request is ended.");
    }

    private JobStatus checkJobStatus() {
        APCCResponse res = this.getStatus(this.curJobID);
        if (res == null) {
            return JobStatus.NONE;
        }
        return this.checkJobStatus(res);
    }

    private JobStatus checkJobStatus(APCCResponse res) {
        JobResponse jobRes = null;
        InfoResponse infoRes = null;
        if (res instanceof JobResponse) {
            jobRes = (JobResponse)res;
        } else if (res instanceof InfoResponse) {
            infoRes = (InfoResponse)res;
        } else {
            this.printMessage("[Error] Failed to get response from server.");
            return JobStatus.FAILED;
        }
        if (infoRes != null) {
            System.out.println(infoRes.getMessage());
            System.out.println(infoRes.data.getInfo());
            if (infoRes.getStatus() != APCCResponseStatus.STATUS_ACCEPTED.code && infoRes.getStatus() != APCCResponseStatus.STATUS_OK.code) {
                this.printMessage("[ERROR] " + infoRes.getMessage() + " - " + infoRes.data.getInfo());
                return JobStatus.FAILED;
            }
        } else if (jobRes != null) {
            this.curJobInfo = jobRes.getData();
            this.curJobID = this.curJobInfo.getId();
            this.printJobStatus();
            return JobStatus.getJobStatus((String)this.curJobInfo.getStatus());
        }
        return JobStatus.FAILED;
    }

    private void printJobStatus() {
        if (this.curJobInfo == null) {
            return;
        }
        System.out.println("[Job " + this.curJobInfo.getId() + "] " + this.curJobInfo.getMessage());
    }

    private void printMessage(String msg) {
        Calendar curCal = Calendar.getInstance();
        Date curDate = curCal.getTime();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        String dateString = format.format(curDate);
        if (this.curJobInfo != null) {
            System.out.print("[Job " + this.curJobInfo.getId() + "] ");
        }
        System.out.println("[" + dateString + "] " + msg);
    }

    private APCCResponse sendRequest(Request request) {
        APCCResponse response = null;
        String result = "";
        try {
            RestTemplate restTemplate = RestTemplateConfig.getRestTemplate();
            ResponseEntity res = restTemplate.postForEntity(this.env.getRequestUrl(), (Object)request, String.class, new Object[0]);
            result = (String)res.getBody();
            System.out.println(result);
        }
        catch (RestClientResponseException ex) {
            System.out.println(ex.getMessage());
            result = ex.getResponseBodyAsString();
            System.out.println(result);
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        System.out.println(result);
        response = this.toResponse(result);
        return response;
    }

    private void download() throws Exception {
        String downloadUrl = this.curJobInfo.getDownload_url();
        if (this.target == null || this.target.length() == 0) {
            this.printMessage("[Error] The target file path is not inputed.");
            return;
        }
        this.printMessage("[Info] Download Start - " + downloadUrl);
        URL website = new URL(downloadUrl);
        ReadableByteChannel rbc = Channels.newChannel(website.openStream());
        FileOutputStream fos = new FileOutputStream(this.target);
        Long byteWritten = fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
        this.printMessage("[Info] Download Successfully.");
        System.out.println("File name : " + this.target);
        System.out.println("of bytes  : " + byteWritten);
        fos.close();
        rbc.close();
    }

    private APCCResponse getStatus(String jobid) {
        APCCResponse apccRes = null;
        String result = "";
        try {
            LinkedMultiValueMap map = new LinkedMultiValueMap();
            map.add((Object)"jobid", (Object)jobid);
            RestTemplate restTemplate = RestTemplateConfig.getRestTemplate();
            ResponseEntity res = restTemplate.postForEntity(this.env.getStatusUrl(), (Object)map, String.class, new Object[0]);
            result = (String)res.getBody();
        }
        catch (RestClientResponseException ex) {
            result = ex.getResponseBodyAsString();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
            return null;
        }
        apccRes = this.toResponse(result);
        return apccRes;
    }

    private JobDetails toJobDetails(String jsonString) {
        ObjectMapper mapper = new ObjectMapper();
        JobDetails res = null;
        try {
            res = (JobDetails)mapper.readValue(jsonString, JobDetailsMME.class);
        }
        catch (Exception ex1) {
            try {
                res = (JobDetails)mapper.readValue(jsonString, JobDetailsModel.class);
            }
            catch (Exception ex2) {
                try {
                    res = (JobDetails)mapper.readValue(jsonString, JobDetailsCMIP5.class);
                }
                catch (Exception ex3) {
                    ex3.printStackTrace();
                    return null;
                }
            }
        }
        return res;
    }

    private APCCResponse toResponse(String jsonString) {
        APCCResponse res = null;
        ObjectMapper mapper = new ObjectMapper();
        try {
            res = (APCCResponse)mapper.readValue(jsonString, InfoResponse.class);
            if (res != null && res.getStatus() > APCCResponseStatus.STATUS_ACCEPTED.code) {
                return res;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            res = (APCCResponse)mapper.readValue(jsonString, JobResponse.class);
            if (res != null) {
                return res;
            }
        }
        catch (Exception ex1) {
            try {
                res = (APCCResponse)mapper.readValue(jsonString, InfoResponse.class);
                if (res != null) {
                    return res;
                }
            }
            catch (Exception ex2) {
                try {
                    res = (APCCResponse)mapper.readValue(jsonString, UserInfoResponse.class);
                    if (res != null) {
                        return res;
                    }
                }
                catch (Exception ex3) {
                    ex3.printStackTrace();
                    return null;
                }
            }
        }
        return null;
    }
}

